/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.platform.Window;
import dev.obscuria.lootjournal.LootJournal;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;

public enum Anchor {
    TOP_LEFT(window -> 0, (window, offset) -> offset, separation -> 12 + separation, false),
    TOP_RIGHT(Window::m_85445_, (window, offset) -> offset, separation -> 12 + separation, true),
    BOTTOM_LEFT(window -> 0, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, false),
    BOTTOM_RIGHT(Window::m_85445_, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, true);

    private final Function<Window, Integer> xFunc;
    private final BiFunction<Window, Integer, Integer> yFunc;
    private final Function<Integer, Integer> stepFunc;
    private final boolean reversed;

    private Anchor(Function<Window, Integer> xFunc, BiFunction<Window, Integer, Integer> yFunc, Function<Integer, Integer> stepFunc, boolean reversed) {
        this.xFunc = xFunc;
        this.yFunc = yFunc;
        this.stepFunc = stepFunc;
        this.reversed = reversed;
    }

    public int getX(Window window) {
        return this.xFunc.apply(window);
    }

    public int getY(Window window) {
        double offset = (double)window.m_85446_() * ((double)LootJournal.CONFIG.anchorPercentOffset * 0.01);
        return this.yFunc.apply(window, (int)offset + LootJournal.CONFIG.anchorPixelOffset);
    }

    public int getStep() {
        return this.stepFunc.apply(LootJournal.CONFIG.separation);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void transform(GuiGraphics graphics, Window window) {
        graphics.m_280168_().m_252880_((float)this.getX(window), (float)this.getY(window), 0.0f);
        float scale = (float)LootJournal.CONFIG.scale * 0.01f;
        graphics.m_280168_().m_85841_(scale, scale, scale);
    }
}

